package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class ST9_trunk extends Trunk
{
	public ST9_trunk( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "ST9 trunk";

		value = 412;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_03.st9:0x000000CAr, "R windshield", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_03.st9:0x000000CAr, "R windshield", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical > 1.0 )
		{
			float part_random = random();
			if ( part_random >= 0.5 ) addPart( cars.cat_03.st9:0x000000E7r, "R wing 3", actcolor, optical, power ); else
			addPart( cars.cat_03.st9:0x000000C8r, "R wing 2", actcolor, optical, power );
		}
	}
}
